% MATLAB code: Example 11.3, Figure 11.3
% File: series_CI.m
%
% Generation of nonlinear cointegrated time series:
%    Y_{1,t} = beta_{2,t}Y_{2,t} + beta_{3,t}Y_{3,t} + epsilon_{1,t},
%    Y_{2,t} = Y_{2,t-1} + epsilon_{2,t},
%    Y_{3,t} = Y_{3,t-1} + epsilon_{3,t},
% where 
%   beta_{2,t} = -0.8(1+exp{-2(X_{t}-0.3)})^{-1}
%   beta_{3,t} = (1 + exp{-(X_{t}-1)})^{-1}
%   (epsilon_{1,t},epsilon_{2,t},epsilon_{3,t})' ~ iid N(0,I_{3})
%   X_{t} ~ iid N(0,1)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;

nr    = 1000;
mu    = [0, 0, 0];
Sigma = [1, 0, 0; 0, 1, 0; 0, 0, 1];
R     = mvnrnd(mu,Sigma,nr+1);
X     = normrnd(0,1,nr+1,1);
y2(1) = 0;
y3(1) = 0;

y2(2) = 0;
y3(2) = 0;

ylin(1)=0;

for i=2:nr+1
    a2(i) = -0.8*(1+exp(-2*(X(i) - 0.3)))^(-1);
    a3(i) = (1 + exp(-(X(i)-1)))^(-1);
    y2(i) = y2(i-1) + R(i,2);
    y3(i) = y3(i-1) + R(i,3);

    y1(i)   = a2(i)*y2(i) + a3(i)*y3(i) + R(i,1); 
    ylin(i) = y2(i)+y3(i);
    
end

for i=1:200
    zlin(i) = ylin(i+800); % non-stationary (NS)
    z1(i)   = y1(i+800);   % stationary
    z2(i)   = y2(i+800);   % NS
    z3(i)   = y3(i+800);   % NS
end

zlint = zlin';
z1t   = z1';
z2t   = z2';
z3t   = z3';

    
    
